package editor;

import game.CustomImageDataII;
import game.IntRect;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.awt.image.ImageObserver;

public class DoorSourcePaletteObject extends ScreenPaletteObject {
	
	private RoomEditorPanel destinationPanel;
	private DoorDestinationPaletteObject destination;
	
	public DoorSourcePaletteObject(IntRect theClickRect, int theDistanceToBorder, int theBorderWidth, CustomImageDataII theDoorImage, RoomEditorPanel theSourceRoom, RoomEditorPanel theDestinationRoom) {
		clickRect = theClickRect;
		
		image = theDoorImage;
		
		distanceToBorder = theDistanceToBorder;
		borderWidth = theBorderWidth;
		editorPanel = theSourceRoom;
		destinationPanel = theDestinationRoom;
	}
	
	
	
	@Override
	public ScreenObject create(int objX, int objY, ImageObserver io) {
		return new DoorSourceScreenObject(objX, objY, this);
	}

	@Override
	public void delete(ScreenObject so) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void draw(Graphics g) {
		if(clickRect == null)
			return;
		
		image.drawObjectFromUpperLeftCorner(g, clickRect.getMinX(), clickRect.getMinY());
		
		Color origCol = g.getColor();
		
		FontRenderContext frc = g.getFontMetrics().getFontRenderContext();
		String dispStr = "to: " + this.getDestinationRoom().getStaticBlockFactory().getRoomName();
		Rectangle2D strBounds = g.getFont().getStringBounds(dispStr, frc);
		g.setColor(Color.white);
		g.fillRect(clickRect.getMinX(), clickRect.getMaxY() + 2, 4 + (int) strBounds.getWidth(), 4 + (int) strBounds.getHeight());
		g.setColor(Color.black);
		g.drawString(dispStr, clickRect.getMinX() + 2,  clickRect.getMaxY() + 20);
		
		if(getCaption() != null && getCaptionColor() != null) {
			g.setColor(getCaptionColor());
			
			Font origFont = g.getFont();
			Font newFont = new Font(origFont.getName(), Font.BOLD, 18);
			g.setFont(newFont);
			g.drawString(getCaption(), clickRect.getMinX() + 4, clickRect.getMaxY() - 10);
			g.setFont(origFont);
		}
		
		
		if(isSelected) {
			g.setColor(new Color(255, 200, 0));
		} else {
			g.setColor(new Color(100, 100, 100));
		}
		
		for(int i = 0; i < borderWidth; i++) {
			g.drawRect(clickRect.getMinX() - (distanceToBorder + i), clickRect.getMinY() - (distanceToBorder + i), clickRect.width() + (distanceToBorder + i) * 2, clickRect.height() + (distanceToBorder + i) * 2);
		}
		
		
		g.setColor(origCol);
	}
	
	public int getWidth() {
		return clickRect.width();
	}
	
	public int getHeight() {
		return clickRect.height();
	}
	
	public CustomImageDataII getImage() {
		return image;
	}
	
	public RoomEditorPanel getDestinationRoom() {
		return destinationPanel;
	}
	
	public boolean shouldShowCaption() {
		return editorPanel.doorsShouldShowDestinationsAndSources();
	}



	public DoorDestinationPaletteObject getDestination() {
		return destination;
	}



	public void setDestination(DoorDestinationPaletteObject destination) {
		this.destination = destination;
	}
	
	public Color getCaptionColor() {
		if(destination != null) {
			return destination.getCaptionColor();
		} else
			return null;
	}
	
	public String getCaption() {
		if(destination != null)
			return destination.getCaption();
		else
			return null;
	}
	
	public RoomEditorPanel getSourceRoom() {
		return editorPanel;
	}

}
